/* SIMPLE - Simple Is a Macro Processing Language Element */
/* Copyright (c) 1998 David A. Madore (david.madore@ens.fr) */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * This file is the header for the stack handling routines.
 */

/* A token stack is not unlike a token list, but one level higher: it
 * is a list of token lists. */
typedef struct token_stack {
  token_list *s; /* The stack itself. */
  int depth; /* Depth of the stack. */
  int alldepth; /* Allocated depth. */
} token_stack;

void make_empty_stack(token_stack *ts);

void push_on_stack(token_stack *ts,token_list *tl);

void last_from_stack(token_stack *ts,token_list *tl);

void pop_from_stack(token_stack *ts);

int stack_depth(token_stack *ts);

token_stack *identify_stack(char *name);
