/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "connection.h"

#include "auth.h"

Auth* Auth::mSelf = 0;

class Auth::Private
{
  public:
    QString dn;
    QString uid;
    Group group;
};

Auth::Auth()
  : d( new Private )
{
}

Auth::~Auth()
{
  delete d;
  d = 0;
}

Auth* Auth::self()
{
  if ( !mSelf )
    mSelf = new Auth;

  return mSelf;
}

bool Auth::authenticate( const QString &dn, QString &errorMsg )
{
  QString filter( "objectClass=*" );
  QLdapResponse response = Connection::self()->search( dn, QLdap::Sub, filter );
  if ( !response.isValid() ) {
    errorMsg = Connection::self()->errorString();
    return false;
  }

  if ( response.entries().isEmpty() ) {
    errorMsg = QObject::tr( "Unknown user" );
    return false;
  }

  QLdapEntry entry = response.entries().first();
  d->dn = entry.dn();
  d->uid = entry.value( "uid" );

  Group group( Users );

  filter = QString( "(member=%1)" ).arg( dn );

  QString baseDn = QString( "cn=maintainer,cn=internal,%1" ).arg( Connection::self()->baseDn() );
  response = Connection::self()->search( baseDn, QLdap::Base, filter );
  if ( !response.entries().isEmpty() )
    group = Maintainers;

  baseDn = QString( "cn=admin,cn=internal,%1" ).arg( Connection::self()->baseDn() );
  response = Connection::self()->search( baseDn, QLdap::Base, filter );
  if ( !response.entries().isEmpty() )
    group = Administrators;

  d->group = group;

  return true;
}

QString Auth::dn() const
{
  return d->dn;
}

QString Auth::uid() const
{
  return d->uid;
}

Auth::Group Auth::group() const
{
  return d->group;
}

