.TH "seqstat" 1 "Oct 2002" "SQUID 1.9g" "SQUID Manual"

.SH NAME
.TP 
seqstat - show statistics and format for a sequence file

.SH SYNOPSIS
.B seqstat
.I [options]
.I seqfile

.SH DESCRIPTION

.B seqstat
reads a sequence file
.I seqfile
and shows a number of simple statistics about it.

.pp
The printed statistics include the name of the format, the residue
type of the first sequence (protein, RNA, or DNA), the number of
sequences, the total number of residues, and the average and range of
the sequence lengths.

.SH OPTIONS

.TP
.B -a 
Show additional verbose information: a table with one line per
sequence showing name, length, and description line.
These lines are prefixed with a * character to enable
easily 
.BR grep' ing
them out and sorting them. 

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.B -B
(Babelfish). Autodetect and read a sequence file format other than the
default (FASTA). Almost any common sequence file format is recognized
(including Genbank, EMBL, SWISS-PROT, PIR, and GCG unaligned sequence
formats, and Stockholm, GCG MSF, and Clustal alignment formats). See
the printed documentation for a complete list of supported formats.

.SH EXPERT OPTIONS

.TP
.BI --informat " <s>"
Specify that the sequence file is in format 
.I <s>,
rather than the default FASTA format.
Common examples include Genbank, EMBL, GCG, 
PIR, Stockholm, Clustal, MSF, or PHYLIP; 
see the printed documentation for a complete list
of accepted format names.
This option overrides the default expected format (FASTA)
and the 
.I -B
Babelfish autodetection option.

.TP
.B --quiet
Suppress the verbose header (program name, release number
and date, the parameters and options in effect).

.SH SEE ALSO

.PP
http://www.genetics.wustl.edu/eddy/software/#squid

.SH AUTHOR

SQUID and its documentation are Copyright (C) 1992-2002 HHMI/Washington University School of Medicine
Freely distributed under the GNU General Public License (GPL)
See COPYING in the source code distribution for more details, or contact me.

.nf
Sean Eddy
Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


