; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @llvm.assume(i1)
declare void @use(i8)
declare void @usev2xi8(<2 x i8>)


define i1 @squared_nsw_eq0(i5 %x) {
; CHECK-LABEL: @squared_nsw_eq0(
; CHECK-NEXT:    [[R:%.*]] = icmp eq i5 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = mul nsw i5 %x, %x
  %r = icmp eq i5 %m, 0
  ret i1 %r
}

define <2 x i1> @squared_nuw_eq0(<2 x i8> %x) {
; CHECK-LABEL: @squared_nuw_eq0(
; CHECK-NEXT:    [[R:%.*]] = icmp eq <2 x i8> [[X:%.*]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %m = mul nuw <2 x i8> %x, %x
  %r = icmp eq <2 x i8> %m, zeroinitializer
  ret <2 x i1> %r
}

; extra use is ok

define i1 @squared_nsw_nuw_ne0(i8 %x) {
; CHECK-LABEL: @squared_nsw_nuw_ne0(
; CHECK-NEXT:    [[M:%.*]] = mul nuw nsw i8 [[X:%.*]], [[X]]
; CHECK-NEXT:    call void @use(i8 [[M]])
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[X]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = mul nsw nuw i8 %x, %x
  call void @use(i8 %m)
  %r = icmp ne i8 %m, 0
  ret i1 %r
}

; negative test - must have no-overflow

define i1 @squared_eq0(i8 %x) {
; CHECK-LABEL: @squared_eq0(
; CHECK-NEXT:    [[M:%.*]] = mul i8 [[X:%.*]], [[X]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[M]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = mul i8 %x, %x
  %r = icmp eq i8 %m, 0
  ret i1 %r
}

; negative test - not squared
; TODO: This could be or-of-icmps.

define i1 @mul_nsw_eq0(i5 %x, i5 %y) {
; CHECK-LABEL: @mul_nsw_eq0(
; CHECK-NEXT:    [[M:%.*]] = mul nsw i5 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i5 [[M]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = mul nsw i5 %x, %y
  %r = icmp eq i5 %m, 0
  ret i1 %r
}

; negative test - non-zero cmp

define i1 @squared_nsw_eq1(i5 %x) {
; CHECK-LABEL: @squared_nsw_eq1(
; CHECK-NEXT:    [[M:%.*]] = mul nsw i5 [[X:%.*]], [[X]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i5 [[M]], 1
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = mul nsw i5 %x, %x
  %r = icmp eq i5 %m, 1
  ret i1 %r
}

define i1 @squared_nsw_sgt0(i5 %x) {
; CHECK-LABEL: @squared_nsw_sgt0(
; CHECK-NEXT:    [[R:%.*]] = icmp ne i5 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %m = mul nsw i5 %x, %x
  %r = icmp sgt i5 %m, 0
  ret i1 %r
}

; Tests for slt/ult

define i1 @slt_positive_multip_rem_zero(i8 %x) {
; CHECK-LABEL: @slt_positive_multip_rem_zero(
; CHECK-NEXT:    [[B:%.*]] = icmp slt i8 [[X:%.*]], 3
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nsw i8 %x, 7
  %b = icmp slt i8 %a, 21
  ret i1 %b
}

define i1 @slt_negative_multip_rem_zero(i8 %x) {
; CHECK-LABEL: @slt_negative_multip_rem_zero(
; CHECK-NEXT:    [[B:%.*]] = icmp sgt i8 [[X:%.*]], -3
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nsw i8 %x, -7
  %b = icmp slt i8 %a, 21
  ret i1 %b
}

define i1 @slt_positive_multip_rem_nz(i8 %x) {
; CHECK-LABEL: @slt_positive_multip_rem_nz(
; CHECK-NEXT:    [[B:%.*]] = icmp slt i8 [[X:%.*]], 5
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nsw i8 %x, 5
  %b = icmp slt i8 %a, 21
  ret i1 %b
}

define i1 @ult_rem_zero(i8 %x) {
; CHECK-LABEL: @ult_rem_zero(
; CHECK-NEXT:    [[B:%.*]] = icmp ult i8 [[X:%.*]], 3
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nuw i8 %x, 7
  %b = icmp ult i8 %a, 21
  ret i1 %b
}

; Same as above, but with nsw flag too.
; This used to not optimize due to nsw being prioritized too much.
define i1 @ult_rem_zero_nsw(i8 %x) {
; CHECK-LABEL: @ult_rem_zero_nsw(
; CHECK-NEXT:    [[B:%.*]] = icmp ult i8 [[X:%.*]], 3
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nuw nsw i8 %x, 7
  %b = icmp ult i8 %a, 21
  ret i1 %b
}

define i1 @ult_rem_nz(i8 %x) {
; CHECK-LABEL: @ult_rem_nz(
; CHECK-NEXT:    [[B:%.*]] = icmp ult i8 [[X:%.*]], 5
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nuw i8 %x, 5
  %b = icmp ult i8 %a, 21
  ret i1 %b
}

; Same as above, but with nsw flag too.
; This used to not optimize due to nsw being prioritized too much.
define i1 @ult_rem_nz_nsw(i8 %x) {
; CHECK-LABEL: @ult_rem_nz_nsw(
; CHECK-NEXT:    [[B:%.*]] = icmp ult i8 [[X:%.*]], 5
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nuw nsw i8 %x, 5
  %b = icmp ult i8 %a, 21
  ret i1 %b
}

; Tests for sgt/ugt

define i1 @sgt_positive_multip_rem_zero(i8 %x) {
; CHECK-LABEL: @sgt_positive_multip_rem_zero(
; CHECK-NEXT:    [[B:%.*]] = icmp sgt i8 [[X:%.*]], 3
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nsw i8 %x, 7
  %b = icmp sgt i8 %a, 21
  ret i1 %b
}

define i1 @sgt_negative_multip_rem_zero(i8 %x) {
; CHECK-LABEL: @sgt_negative_multip_rem_zero(
; CHECK-NEXT:    [[B:%.*]] = icmp slt i8 [[X:%.*]], -3
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nsw i8 %x, -7
  %b = icmp sgt i8 %a, 21
  ret i1 %b
}

define i1 @sgt_positive_multip_rem_nz(i8 %x) {
; CHECK-LABEL: @sgt_positive_multip_rem_nz(
; CHECK-NEXT:    [[B:%.*]] = icmp sgt i8 [[X:%.*]], 4
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nsw i8 %x, 5
  %b = icmp sgt i8 %a, 21
  ret i1 %b
}

define i1 @ugt_rem_zero(i8 %x) {
; CHECK-LABEL: @ugt_rem_zero(
; CHECK-NEXT:    [[B:%.*]] = icmp ugt i8 [[X:%.*]], 3
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nuw i8 %x, 7
  %b = icmp ugt i8 %a, 21
  ret i1 %b
}

; Same as above, but with nsw flag too.
; This used to not optimize due to nsw being prioritized too much.
define i1 @ugt_rem_zero_nsw(i8 %x) {
; CHECK-LABEL: @ugt_rem_zero_nsw(
; CHECK-NEXT:    [[B:%.*]] = icmp ugt i8 [[X:%.*]], 3
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nuw nsw i8 %x, 7
  %b = icmp ugt i8 %a, 21
  ret i1 %b
}

define i1 @ugt_rem_nz(i8 %x) {
; CHECK-LABEL: @ugt_rem_nz(
; CHECK-NEXT:    [[B:%.*]] = icmp ugt i8 [[X:%.*]], 4
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nuw i8 %x, 5
  %b = icmp ugt i8 %a, 21
  ret i1 %b
}

; Same as above, but with nsw flag too.
; This used to not optimize due to nsw being prioritized too much.
define i1 @ugt_rem_nz_nsw(i8 %x) {
; CHECK-LABEL: @ugt_rem_nz_nsw(
; CHECK-NEXT:    [[B:%.*]] = icmp ugt i8 [[X:%.*]], 4
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nuw nsw i8 %x, 5
  %b = icmp ugt i8 %a, 21
  ret i1 %b
}

; Tests for eq/ne

define i1 @eq_nsw_rem_zero(i8 %x) {
; CHECK-LABEL: @eq_nsw_rem_zero(
; CHECK-NEXT:    [[B:%.*]] = icmp eq i8 [[X:%.*]], -4
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nsw i8 %x, -5
  %b = icmp eq i8 %a, 20
  ret i1 %b
}

define <2 x i1> @ne_nsw_rem_zero(<2 x i8> %x) {
; CHECK-LABEL: @ne_nsw_rem_zero(
; CHECK-NEXT:    [[B:%.*]] = icmp ne <2 x i8> [[X:%.*]], splat (i8 -6)
; CHECK-NEXT:    ret <2 x i1> [[B]]
;
  %a = mul nsw <2 x i8> %x, <i8 5, i8 5>
  %b = icmp ne <2 x i8> %a, <i8 -30, i8 -30>
  ret <2 x i1> %b
}

; TODO: Missed fold with undef.

define <2 x i1> @ne_nsw_rem_zero_undef1(<2 x i8> %x) {
; CHECK-LABEL: @ne_nsw_rem_zero_undef1(
; CHECK-NEXT:    [[A:%.*]] = mul nsw <2 x i8> [[X:%.*]], <i8 5, i8 undef>
; CHECK-NEXT:    [[B:%.*]] = icmp ne <2 x i8> [[A]], splat (i8 -30)
; CHECK-NEXT:    ret <2 x i1> [[B]]
;
  %a = mul nsw <2 x i8> %x, <i8 5, i8 undef>
  %b = icmp ne <2 x i8> %a, <i8 -30, i8 -30>
  ret <2 x i1> %b
}

; TODO: Missed fold with undef.

define <2 x i1> @ne_nsw_rem_zero_undef2(<2 x i8> %x) {
; CHECK-LABEL: @ne_nsw_rem_zero_undef2(
; CHECK-NEXT:    [[A:%.*]] = mul nsw <2 x i8> [[X:%.*]], splat (i8 5)
; CHECK-NEXT:    [[B:%.*]] = icmp ne <2 x i8> [[A]], <i8 -30, i8 undef>
; CHECK-NEXT:    ret <2 x i1> [[B]]
;
  %a = mul nsw <2 x i8> %x, <i8 5, i8 5>
  %b = icmp ne <2 x i8> %a, <i8 -30, i8 undef>
  ret <2 x i1> %b
}

define i1 @eq_nsw_rem_zero_uses(i8 %x) {
; CHECK-LABEL: @eq_nsw_rem_zero_uses(
; CHECK-NEXT:    [[A:%.*]] = mul nsw i8 [[X:%.*]], -5
; CHECK-NEXT:    call void @use(i8 [[A]])
; CHECK-NEXT:    [[B:%.*]] = icmp eq i8 [[X]], -4
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nsw i8 %x, -5
  call void @use(i8 %a)
  %b = icmp eq i8 %a, 20
  ret i1 %b
}

; Impossible multiple should be handled by instsimplify.

define i1 @eq_nsw_rem_nz(i8 %x) {
; CHECK-LABEL: @eq_nsw_rem_nz(
; CHECK-NEXT:    ret i1 false
;
  %a = mul nsw i8 %x, 5
  %b = icmp eq i8 %a, 245
  ret i1 %b
}

; Impossible multiple should be handled by instsimplify.

define i1 @ne_nsw_rem_nz(i8 %x) {
; CHECK-LABEL: @ne_nsw_rem_nz(
; CHECK-NEXT:    ret i1 true
;
  %a = mul nsw i8 %x, 5
  %b = icmp ne i8 %a, 130
  ret i1 %b
}

define <2 x i1> @eq_nuw_rem_zero(<2 x i8> %x) {
; CHECK-LABEL: @eq_nuw_rem_zero(
; CHECK-NEXT:    [[B:%.*]] = icmp eq <2 x i8> [[X:%.*]], splat (i8 4)
; CHECK-NEXT:    ret <2 x i1> [[B]]
;
  %a = mul nuw <2 x i8> %x, <i8 5, i8 5>
  %b = icmp eq <2 x i8> %a, <i8 20, i8 20>
  ret <2 x i1> %b
}

; TODO: Missed fold with undef.

define <2 x i1> @eq_nuw_rem_zero_undef1(<2 x i8> %x) {
; CHECK-LABEL: @eq_nuw_rem_zero_undef1(
; CHECK-NEXT:    [[A:%.*]] = mul nuw <2 x i8> [[X:%.*]], <i8 undef, i8 5>
; CHECK-NEXT:    [[B:%.*]] = icmp eq <2 x i8> [[A]], splat (i8 20)
; CHECK-NEXT:    ret <2 x i1> [[B]]
;
  %a = mul nuw <2 x i8> %x, <i8 undef, i8 5>
  %b = icmp eq <2 x i8> %a, <i8 20, i8 20>
  ret <2 x i1> %b
}

; TODO: Missed fold with undef.

define <2 x i1> @eq_nuw_rem_zero_undef2(<2 x i8> %x) {
; CHECK-LABEL: @eq_nuw_rem_zero_undef2(
; CHECK-NEXT:    [[A:%.*]] = mul nuw <2 x i8> [[X:%.*]], splat (i8 5)
; CHECK-NEXT:    [[B:%.*]] = icmp eq <2 x i8> [[A]], <i8 undef, i8 20>
; CHECK-NEXT:    ret <2 x i1> [[B]]
;
  %a = mul nuw <2 x i8> %x, <i8 5, i8 5>
  %b = icmp eq <2 x i8> %a, <i8 undef, i8 20>
  ret <2 x i1> %b
}

define i1 @ne_nuw_rem_zero(i8 %x) {
; CHECK-LABEL: @ne_nuw_rem_zero(
; CHECK-NEXT:    [[B:%.*]] = icmp ne i8 [[X:%.*]], 26
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nuw i8 %x, 5
  %b = icmp ne i8 %a, 130
  ret i1 %b
}

define i1 @ne_nuw_rem_zero_uses(i8 %x) {
; CHECK-LABEL: @ne_nuw_rem_zero_uses(
; CHECK-NEXT:    [[A:%.*]] = mul nuw i8 [[X:%.*]], 5
; CHECK-NEXT:    call void @use(i8 [[A]])
; CHECK-NEXT:    [[B:%.*]] = icmp ne i8 [[X]], 26
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul nuw i8 %x, 5
  call void @use(i8 %a)
  %b = icmp ne i8 %a, 130
  ret i1 %b
}

; Impossible multiple should be handled by instsimplify.

define i1 @eq_nuw_rem_nz(i8 %x) {
; CHECK-LABEL: @eq_nuw_rem_nz(
; CHECK-NEXT:    ret i1 false
;
  %a = mul nuw i8 %x, -5
  %b = icmp eq i8 %a, 20
  ret i1 %b
}

; Impossible multiple should be handled by instsimplify.

define i1 @ne_nuw_rem_nz(i8 %x) {
; CHECK-LABEL: @ne_nuw_rem_nz(
; CHECK-NEXT:    ret i1 true
;
  %a = mul nuw i8 %x, 5
  %b = icmp ne i8 %a, -30
  ret i1 %b
}

; Negative tests for the icmp mul folds

define i1 @sgt_positive_multip_rem_zero_nonsw(i8 %x) {
; CHECK-LABEL: @sgt_positive_multip_rem_zero_nonsw(
; CHECK-NEXT:    [[A:%.*]] = mul i8 [[X:%.*]], 7
; CHECK-NEXT:    [[B:%.*]] = icmp sgt i8 [[A]], 21
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul i8 %x, 7
  %b = icmp sgt i8 %a, 21
  ret i1 %b
}

define i1 @ult_multip_rem_zero_nonsw(i8 %x) {
; CHECK-LABEL: @ult_multip_rem_zero_nonsw(
; CHECK-NEXT:    [[A:%.*]] = mul i8 [[X:%.*]], 7
; CHECK-NEXT:    [[B:%.*]] = icmp ult i8 [[A]], 21
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul i8 %x, 7
  %b = icmp ult i8 %a, 21
  ret i1 %b
}

define i1 @ugt_rem_zero_nonuw(i8 %x) {
; CHECK-LABEL: @ugt_rem_zero_nonuw(
; CHECK-NEXT:    [[A:%.*]] = mul i8 [[X:%.*]], 7
; CHECK-NEXT:    [[B:%.*]] = icmp ugt i8 [[A]], 21
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul i8 %x, 7
  %b = icmp ugt i8 %a, 21
  ret i1 %b
}

define i1 @sgt_minnum(i8 %x) {
; CHECK-LABEL: @sgt_minnum(
; CHECK-NEXT:    ret i1 true
;
  %a = mul nsw i8 %x, 7
  %b = icmp sgt i8 %a, -128
  ret i1 %b
}

define i1 @ule_bignum(i8 %x) {
; CHECK-LABEL: @ule_bignum(
; CHECK-NEXT:    [[B:%.*]] = icmp eq i8 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul i8 %x, 2147483647
  %b = icmp ule i8 %a, 0
  ret i1 %b
}

define i1 @sgt_mulzero(i8 %x) {
; CHECK-LABEL: @sgt_mulzero(
; CHECK-NEXT:    ret i1 false
;
  %a = mul nsw i8 %x, 0
  %b = icmp sgt i8 %a, 21
  ret i1 %b
}

define i1 @eq_rem_zero_nonuw(i8 %x) {
; CHECK-LABEL: @eq_rem_zero_nonuw(
; CHECK-NEXT:    [[B:%.*]] = icmp eq i8 [[X:%.*]], 4
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul i8 %x, 5
  %b = icmp eq i8 %a, 20
  ret i1 %b
}

define i1 @ne_rem_zero_nonuw(i8 %x) {
; CHECK-LABEL: @ne_rem_zero_nonuw(
; CHECK-NEXT:    [[B:%.*]] = icmp ne i8 [[X:%.*]], 6
; CHECK-NEXT:    ret i1 [[B]]
;
  %a = mul i8 %x, 5
  %b = icmp ne i8 %a, 30
  ret i1 %b
}

define i1 @mul_constant_eq(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_constant_eq(
; CHECK-NEXT:    [[C:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul i32 %x, 5
  %B = mul i32 %y, 5
  %C = icmp eq i32 %A, %B
  ret i1 %C
}

define <2 x i1> @mul_constant_ne_splat(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @mul_constant_ne_splat(
; CHECK-NEXT:    [[C:%.*]] = icmp ne <2 x i32> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %A = mul <2 x i32> %x, <i32 5, i32 5>
  %B = mul <2 x i32> %y, <i32 5, i32 5>
  %C = icmp ne <2 x i32> %A, %B
  ret <2 x i1> %C
}

define i1 @mul_constant_ne_extra_use1(i8 %x, i8 %y) {
; CHECK-LABEL: @mul_constant_ne_extra_use1(
; CHECK-NEXT:    [[A:%.*]] = mul i8 [[X:%.*]], 5
; CHECK-NEXT:    call void @use(i8 [[A]])
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[X]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul i8 %x, 5
  call void @use(i8 %A)
  %B = mul i8 %y, 5
  %C = icmp ne i8 %A, %B
  ret i1 %C
}

define i1 @mul_constant_eq_extra_use2(i8 %x, i8 %y) {
; CHECK-LABEL: @mul_constant_eq_extra_use2(
; CHECK-NEXT:    [[B:%.*]] = mul i8 [[Y:%.*]], 5
; CHECK-NEXT:    call void @use(i8 [[B]])
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[X:%.*]], [[Y]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul i8 %x, 5
  %B = mul i8 %y, 5
  call void @use(i8 %B)
  %C = icmp eq i8 %A, %B
  ret i1 %C
}

define i1 @mul_constant_ne_extra_use3(i8 %x, i8 %y) {
; CHECK-LABEL: @mul_constant_ne_extra_use3(
; CHECK-NEXT:    [[A:%.*]] = mul i8 [[X:%.*]], 5
; CHECK-NEXT:    call void @use(i8 [[A]])
; CHECK-NEXT:    [[B:%.*]] = mul i8 [[Y:%.*]], 5
; CHECK-NEXT:    call void @use(i8 [[B]])
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul i8 %x, 5
  call void @use(i8 %A)
  %B = mul i8 %y, 5
  call void @use(i8 %B)
  %C = icmp ne i8 %A, %B
  ret i1 %C
}

define i1 @mul_constant_eq_nsw(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_constant_eq_nsw(
; CHECK-NEXT:    [[C:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul nsw i32 %x, 6
  %B = mul nsw i32 %y, 6
  %C = icmp eq i32 %A, %B
  ret i1 %C
}

define <2 x i1> @mul_constant_ne_nsw_splat(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @mul_constant_ne_nsw_splat(
; CHECK-NEXT:    [[C:%.*]] = icmp ne <2 x i32> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %A = mul nsw <2 x i32> %x, <i32 12, i32 12>
  %B = mul nsw <2 x i32> %y, <i32 12, i32 12>
  %C = icmp ne <2 x i32> %A, %B
  ret <2 x i1> %C
}

define i1 @mul_constant_ne_nsw_extra_use1(i8 %x, i8 %y) {
; CHECK-LABEL: @mul_constant_ne_nsw_extra_use1(
; CHECK-NEXT:    [[A:%.*]] = mul nsw i8 [[X:%.*]], 74
; CHECK-NEXT:    call void @use(i8 [[A]])
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[X]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul nsw i8 %x, 74
  call void @use(i8 %A)
  %B = mul nsw i8 %y, 74
  %C = icmp ne i8 %A, %B
  ret i1 %C
}

define i1 @mul_constant_eq_nsw_extra_use2(i8 %x, i8 %y) {
; CHECK-LABEL: @mul_constant_eq_nsw_extra_use2(
; CHECK-NEXT:    [[B:%.*]] = mul nsw i8 [[Y:%.*]], 20
; CHECK-NEXT:    call void @use(i8 [[B]])
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[X:%.*]], [[Y]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul nsw i8 %x, 20
  %B = mul nsw i8 %y, 20
  call void @use(i8 %B)
  %C = icmp eq i8 %A, %B
  ret i1 %C
}

define i1 @mul_constant_ne_nsw_extra_use3(i8 %x, i8 %y) {
; CHECK-LABEL: @mul_constant_ne_nsw_extra_use3(
; CHECK-NEXT:    [[A:%.*]] = mul nsw i8 [[X:%.*]], 24
; CHECK-NEXT:    call void @use(i8 [[A]])
; CHECK-NEXT:    [[B:%.*]] = mul nsw i8 [[Y:%.*]], 24
; CHECK-NEXT:    call void @use(i8 [[B]])
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul nsw i8 %x, 24
  call void @use(i8 %A)
  %B = mul nsw i8 %y, 24
  call void @use(i8 %B)
  %C = icmp ne i8 %A, %B
  ret i1 %C
}

define i1 @mul_constant_nuw_eq(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_constant_nuw_eq(
; CHECK-NEXT:    [[C:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul nuw i32 %x, 22
  %B = mul nuw i32 %y, 22
  %C = icmp eq i32 %A, %B
  ret i1 %C
}

define <2 x i1> @mul_constant_ne_nuw_splat(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @mul_constant_ne_nuw_splat(
; CHECK-NEXT:    [[C:%.*]] = icmp ne <2 x i32> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %A = mul nuw <2 x i32> %x, <i32 10, i32 10>
  %B = mul nuw <2 x i32> %y, <i32 10, i32 10>
  %C = icmp ne <2 x i32> %A, %B
  ret <2 x i1> %C
}

define i1 @mul_constant_ne_nuw_extra_use1(i8 %x, i8 %y) {
; CHECK-LABEL: @mul_constant_ne_nuw_extra_use1(
; CHECK-NEXT:    [[A:%.*]] = mul nuw i8 [[X:%.*]], 6
; CHECK-NEXT:    call void @use(i8 [[A]])
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[X]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul nuw i8 %x, 6
  call void @use(i8 %A)
  %B = mul nuw i8 %y, 6
  %C = icmp ne i8 %A, %B
  ret i1 %C
}

define i1 @mul_constant_eq_nuw_extra_use2(i8 %x, i8 %y) {
; CHECK-LABEL: @mul_constant_eq_nuw_extra_use2(
; CHECK-NEXT:    [[B:%.*]] = mul nuw i8 [[Y:%.*]], 36
; CHECK-NEXT:    call void @use(i8 [[B]])
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[X:%.*]], [[Y]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul nuw i8 %x, 36
  %B = mul nuw i8 %y, 36
  call void @use(i8 %B)
  %C = icmp eq i8 %A, %B
  ret i1 %C
}

define i1 @mul_constant_ne_nuw_extra_use3(i8 %x, i8 %y) {
; CHECK-LABEL: @mul_constant_ne_nuw_extra_use3(
; CHECK-NEXT:    [[A:%.*]] = mul nuw i8 [[X:%.*]], 38
; CHECK-NEXT:    call void @use(i8 [[A]])
; CHECK-NEXT:    [[B:%.*]] = mul nuw i8 [[Y:%.*]], 38
; CHECK-NEXT:    call void @use(i8 [[B]])
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul nuw i8 %x, 38
  call void @use(i8 %A)
  %B = mul nuw i8 %y, 38
  call void @use(i8 %B)
  %C = icmp ne i8 %A, %B
  ret i1 %C
}

; Negative test - wrong pred

define i1 @mul_constant_ult(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_constant_ult(
; CHECK-NEXT:    [[A:%.*]] = mul i32 [[X:%.*]], 47
; CHECK-NEXT:    [[B:%.*]] = mul i32 [[Y:%.*]], 47
; CHECK-NEXT:    [[C:%.*]] = icmp ult i32 [[A]], [[B]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul i32 %x, 47
  %B = mul i32 %y, 47
  %C = icmp ult i32 %A, %B
  ret i1 %C
}

; Negative test - wrong pred

define i1 @mul_constant_nuw_sgt(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_constant_nuw_sgt(
; CHECK-NEXT:    [[A:%.*]] = mul nuw i32 [[X:%.*]], 46
; CHECK-NEXT:    [[B:%.*]] = mul nuw i32 [[Y:%.*]], 46
; CHECK-NEXT:    [[C:%.*]] = icmp sgt i32 [[A]], [[B]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul nuw i32 %x, 46
  %B = mul nuw i32 %y, 46
  %C = icmp sgt i32 %A, %B
  ret i1 %C
}

; Negative test - wrong constants

define i1 @mul_mismatch_constant_nuw_eq(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_mismatch_constant_nuw_eq(
; CHECK-NEXT:    [[A:%.*]] = mul nuw i32 [[X:%.*]], 46
; CHECK-NEXT:    [[B:%.*]] = mul nuw i32 [[Y:%.*]], 44
; CHECK-NEXT:    [[C:%.*]] = icmp eq i32 [[A]], [[B]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul nuw i32 %x, 46
  %B = mul nuw i32 %y, 44
  %C = icmp eq i32 %A, %B
  ret i1 %C
}

; If the multiply constant has any trailing zero bits but could overflow,
; we get something completely different.
; We mask off the high bits of each input and then convert:
; (X&Z) == (Y&Z) -> (X^Y) & Z == 0

define i1 @mul_constant_partial_nuw_eq(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_constant_partial_nuw_eq(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 1073741823
; CHECK-NEXT:    [[C:%.*]] = icmp eq i32 [[TMP2]], 0
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul i32 %x, 44
  %B = mul nuw i32 %y, 44
  %C = icmp eq i32 %A, %B
  ret i1 %C
}

define i1 @mul_constant_mismatch_wrap_eq(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_constant_mismatch_wrap_eq(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 2147483647
; CHECK-NEXT:    [[C:%.*]] = icmp eq i32 [[TMP2]], 0
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul nsw i32 %x, 54
  %B = mul nuw i32 %y, 54
  %C = icmp eq i32 %A, %B
  ret i1 %C
}

define i1 @eq_mul_constants_with_tz(i32 %x, i32 %y) {
; CHECK-LABEL: @eq_mul_constants_with_tz(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 1073741823
; CHECK-NEXT:    [[C:%.*]] = icmp ne i32 [[TMP2]], 0
; CHECK-NEXT:    ret i1 [[C]]
;
  %A = mul i32 %x, 12
  %B = mul i32 %y, 12
  %C = icmp ne i32 %A, %B
  ret i1 %C
}

define <2 x i1> @eq_mul_constants_with_tz_splat(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @eq_mul_constants_with_tz_splat(
; CHECK-NEXT:    [[TMP1:%.*]] = xor <2 x i32> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = and <2 x i32> [[TMP1]], splat (i32 1073741823)
; CHECK-NEXT:    [[C:%.*]] = icmp eq <2 x i32> [[TMP2]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %A = mul <2 x i32> %x, <i32 12, i32 12>
  %B = mul <2 x i32> %y, <i32 12, i32 12>
  %C = icmp eq <2 x i32> %A, %B
  ret <2 x i1> %C
}

@g = extern_weak global i32

define i1 @oss_fuzz_39934(i32 %arg) {
; CHECK-LABEL: @oss_fuzz_39934(
; CHECK-NEXT:    [[C10:%.*]] = icmp ne i32 [[ARG:%.*]], 1
; CHECK-NEXT:    ret i1 [[C10]]
;
  %B13 = mul nsw i32 %arg, -65536
  %cmp = icmp eq ptr @g, null
  %ext = zext i1 %cmp to i32
  %or = or i32 %ext, 65537
  %mul = mul i32 %or, -65536
  %C10 = icmp ne i32 %mul, %B13
  ret i1 %C10
}

define i1 @mul_of_bool(i32 %x, i8 %y) {
; CHECK-LABEL: @mul_of_bool(
; CHECK-NEXT:    ret i1 false
;
  %b = and i32 %x, 1
  %z = zext i8 %y to i32
  %m = mul i32 %b, %z
  %r = icmp ugt i32 %m, 255
  ret i1 %r
}

define i1 @mul_of_bool_commute(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_of_bool_commute(
; CHECK-NEXT:    ret i1 false
;
  %x1 = and i32 %x, 1
  %y8 = and i32 %y, 255
  %m = mul i32 %y8, %x1
  %r = icmp ugt i32 %m, 255
  ret i1 %r
}

define i1 @mul_of_bools(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_of_bools(
; CHECK-NEXT:    ret i1 true
;
  %x1 = and i32 %x, 1
  %y1 = and i32 %y, 1
  %m = mul i32 %x1, %y1
  %r = icmp ult i32 %m, 2
  ret i1 %r
}

; negative test - not a mask of low bit

define i1 @not_mul_of_bool(i32 %x, i8 %y) {
; CHECK-LABEL: @not_mul_of_bool(
; CHECK-NEXT:    [[Q:%.*]] = and i32 [[X:%.*]], 3
; CHECK-NEXT:    [[Z:%.*]] = zext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[M:%.*]] = mul nuw nsw i32 [[Q]], [[Z]]
; CHECK-NEXT:    [[R:%.*]] = icmp samesign ugt i32 [[M]], 255
; CHECK-NEXT:    ret i1 [[R]]
;
  %q = and i32 %x, 3
  %z = zext i8 %y to i32
  %m = mul i32 %q, %z
  %r = icmp ugt i32 %m, 255
  ret i1 %r
}

; negative test - not a single low bit

define i1 @not_mul_of_bool_commute(i32 %x, i32 %y) {
; CHECK-LABEL: @not_mul_of_bool_commute(
; CHECK-NEXT:    [[X30:%.*]] = lshr i32 [[X:%.*]], 30
; CHECK-NEXT:    [[Y8:%.*]] = and i32 [[Y:%.*]], 255
; CHECK-NEXT:    [[M:%.*]] = mul nuw nsw i32 [[Y8]], [[X30]]
; CHECK-NEXT:    [[R:%.*]] = icmp samesign ugt i32 [[M]], 255
; CHECK-NEXT:    ret i1 [[R]]
;
  %x30 = lshr i32 %x, 30
  %y8 = and i32 %y, 255
  %m = mul i32 %y8, %x30
  %r = icmp ugt i32 %m, 255
  ret i1 %r
}

; no leading zeros for 's', but we reduce this with other transforms

define i1 @mul_of_bool_no_lz_other_op(i32 %x, i8 %y) {
; CHECK-LABEL: @mul_of_bool_no_lz_other_op(
; CHECK-NEXT:    ret i1 false
;
  %b = and i32 %x, 1
  %s = sext i8 %y to i32
  %m = mul nuw nsw i32 %b, %s
  %r = icmp sgt i32 %m, 127
  ret i1 %r
}

; high and low bits are known 0

define i1 @mul_of_pow2(i32 %x, i8 %y) {
; CHECK-LABEL: @mul_of_pow2(
; CHECK-NEXT:    ret i1 false
;
  %b = and i32 %x, 2
  %z = zext i8 %y to i32
  %m = mul i32 %b, %z
  %r = icmp ugt i32 %m, 510
  ret i1 %r
}

; high and low bits are known 0

define i1 @mul_of_pow2_commute(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_of_pow2_commute(
; CHECK-NEXT:    ret i1 false
;
  %x4 = and i32 %x, 4
  %y8 = and i32 %y, 255
  %m = mul i32 %y8, %x4
  %r = icmp ugt i32 %m, 1020
  ret i1 %r
}

; only bit 7 can be set by the multiply

define i32 @mul_of_pow2s(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_of_pow2s(
; CHECK-NEXT:    ret i32 128
;
  %x8 = and i32 %x, 8
  %y16 = and i32 %y, 16
  %m = mul i32 %x8, %y16
  %bit7 = or i32 %m, 128
  ret i32 %bit7
}

; negative test - 6 * 255 = 1530 (but constant range analysis can get this)

define i1 @not_mul_of_pow2(i32 %x, i8 %y) {
; CHECK-LABEL: @not_mul_of_pow2(
; CHECK-NEXT:    [[Q:%.*]] = and i32 [[X:%.*]], 6
; CHECK-NEXT:    [[Z:%.*]] = zext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[M:%.*]] = mul nuw nsw i32 [[Q]], [[Z]]
; CHECK-NEXT:    [[R:%.*]] = icmp samesign ugt i32 [[M]], 1530
; CHECK-NEXT:    ret i1 [[R]]
;
  %q = and i32 %x, 6
  %z = zext i8 %y to i32
  %m = mul i32 %q, %z
  %r = icmp ugt i32 %m, 1530
  ret i1 %r
}

; negative test - 12 * 255 = 3060 (but constant range analysis can get this)

define i1 @not_mul_of_pow2_commute(i32 %x, i32 %y) {
; CHECK-LABEL: @not_mul_of_pow2_commute(
; CHECK-NEXT:    [[X30:%.*]] = and i32 [[X:%.*]], 12
; CHECK-NEXT:    [[Y8:%.*]] = and i32 [[Y:%.*]], 255
; CHECK-NEXT:    [[M:%.*]] = mul nuw nsw i32 [[Y8]], [[X30]]
; CHECK-NEXT:    [[R:%.*]] = icmp samesign ugt i32 [[M]], 3060
; CHECK-NEXT:    ret i1 [[R]]
;
  %x30 = and i32 %x, 12
  %y8 = and i32 %y, 255
  %m = mul i32 %y8, %x30
  %r = icmp ugt i32 %m, 3060
  ret i1 %r
}

; negative test - no leading zeros for 's'
; TODO: If analysis was generalized for sign bits, we could reduce this to false.

define i1 @mul_of_pow2_no_lz_other_op(i32 %x, i8 %y) {
; CHECK-LABEL: @mul_of_pow2_no_lz_other_op(
; CHECK-NEXT:    [[B:%.*]] = and i32 [[X:%.*]], 2
; CHECK-NEXT:    [[S:%.*]] = sext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[M:%.*]] = mul nuw nsw i32 [[B]], [[S]]
; CHECK-NEXT:    [[R:%.*]] = icmp sgt i32 [[M]], 254
; CHECK-NEXT:    ret i1 [[R]]
;
  %b = and i32 %x, 2
  %s = sext i8 %y to i32
  %m = mul nuw nsw i32 %b, %s
  %r = icmp sgt i32 %m, 254
  ret i1 %r
}

; The top 32-bits must be zero.

define i1 @splat_mul_known_lz(i32 %x) {
; CHECK-LABEL: @splat_mul_known_lz(
; CHECK-NEXT:    ret i1 true
;
  %z = zext i32 %x to i128
  %m = mul i128 %z, 18446744078004518913 ; 0x00000000_00000001_00000001_00000001
  %s = lshr i128 %m, 96
  %r = icmp eq i128 %s, 0
  ret i1 %r
}

; The 33rd bit can only be set when MSB of x is set.

define i1 @splat_mul_unknown_lz(i32 %x) {
; CHECK-LABEL: @splat_mul_unknown_lz(
; CHECK-NEXT:    [[R:%.*]] = icmp sgt i32 [[X:%.*]], -1
; CHECK-NEXT:    ret i1 [[R]]
;
  %z = zext i32 %x to i128
  %m = mul i128 %z, 18446744078004518913 ; 0x00000000_00000001_00000001_00000001
  %s = lshr i128 %m, 95
  %r = icmp eq i128 %s, 0
  ret i1 %r
}

define i1 @mul_oddC_overflow_eq(i8 %v) {
; CHECK-LABEL: @mul_oddC_overflow_eq(
; CHECK-NEXT:    [[MUL:%.*]] = mul i8 [[V:%.*]], 5
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[MUL]], 101
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %mul = mul i8 %v, 5
  %cmp = icmp eq i8 %mul, 101
  ret i1 %cmp
}

define i1 @mul_oddC_eq_nomod(i8 %v) {
; CHECK-LABEL: @mul_oddC_eq_nomod(
; CHECK-NEXT:    [[MUL:%.*]] = mul i8 [[V:%.*]], 3
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[MUL]], 34
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %mul = mul i8 %v, 3
  %cmp = icmp eq i8 %mul, 34
  ret i1 %cmp
}

define i1 @mul_evenC_ne(i8 %v) {
; CHECK-LABEL: @mul_evenC_ne(
; CHECK-NEXT:    [[MUL:%.*]] = mul i8 [[V:%.*]], 6
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[MUL]], 36
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %mul = mul i8 %v, 6
  %cmp = icmp ne i8 %mul, 36
  ret i1 %cmp
}

define <2 x i1> @mul_oddC_ne_vec(<2 x i8> %v) {
; CHECK-LABEL: @mul_oddC_ne_vec(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i8> [[V:%.*]], splat (i8 4)
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %mul = mul <2 x i8> %v, <i8 3, i8 3>
  %cmp = icmp ne <2 x i8> %mul, <i8 12, i8 12>
  ret <2 x i1> %cmp
}

define <2 x i1> @mul_oddC_ne_nosplat_vec(<2 x i8> %v) {
; CHECK-LABEL: @mul_oddC_ne_nosplat_vec(
; CHECK-NEXT:    [[MUL:%.*]] = mul <2 x i8> [[V:%.*]], <i8 3, i8 5>
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i8> [[MUL]], <i8 12, i8 15>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %mul = mul <2 x i8> %v, <i8 3, i8 5>
  %cmp = icmp ne <2 x i8> %mul, <i8 12, i8 15>
  ret <2 x i1> %cmp
}

define i1 @mul_nsuw_xy_z_maybe_zero_eq(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @mul_nsuw_xy_z_maybe_zero_eq(
; CHECK-NEXT:    [[MULX:%.*]] = mul nuw nsw i8 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    [[MULY:%.*]] = mul nuw nsw i8 [[Y:%.*]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[MULX]], [[MULY]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %mulx = mul nsw nuw i8 %x, %z
  %muly = mul nsw nuw i8 %y, %z
  %cmp = icmp eq i8 %mulx, %muly
  ret i1 %cmp
}

define i1 @mul_xy_z_assumenozero_ne(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @mul_xy_z_assumenozero_ne(
; CHECK-NEXT:    [[NZ:%.*]] = icmp ne i8 [[Z:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[NZ]])
; CHECK-NEXT:    [[MULX:%.*]] = mul i8 [[X:%.*]], [[Z]]
; CHECK-NEXT:    [[MULY:%.*]] = mul i8 [[Y:%.*]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[MULY]], [[MULX]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %nz = icmp ne i8 %z, 0
  call void @llvm.assume(i1 %nz)
  %mulx = mul i8 %x, %z
  %muly = mul i8 %y, %z
  %cmp = icmp ne i8 %muly, %mulx
  ret i1 %cmp
}

define i1 @mul_xy_z_assumeodd_eq(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @mul_xy_z_assumeodd_eq(
; CHECK-NEXT:    [[LB:%.*]] = and i8 [[Z:%.*]], 1
; CHECK-NEXT:    [[NZ:%.*]] = icmp ne i8 [[LB]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[NZ]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lb = and i8 %z, 1
  %nz = icmp ne i8 %lb, 0
  call void @llvm.assume(i1 %nz)
  %mulx = mul i8 %x, %z
  %muly = mul i8 %z, %y
  %cmp = icmp eq i8 %mulx, %muly
  ret i1 %cmp
}

define <2 x i1> @reused_mul_nsw_xy_z_setnonzero_vec_ne(<2 x i8> %x, <2 x i8> %y, <2 x i8> %zi) {
; CHECK-LABEL: @reused_mul_nsw_xy_z_setnonzero_vec_ne(
; CHECK-NEXT:    [[Z:%.*]] = or <2 x i8> [[ZI:%.*]], splat (i8 4)
; CHECK-NEXT:    [[MULY:%.*]] = mul nsw <2 x i8> [[Y:%.*]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i8> [[Y]], [[X:%.*]]
; CHECK-NEXT:    call void @usev2xi8(<2 x i8> [[MULY]])
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %z = or <2 x i8> %zi, <i8 4, i8 4>
  %mulx = mul nsw <2 x i8> %z, %x
  %muly = mul nsw <2 x i8> %y, %z
  %cmp = icmp ne <2 x i8> %muly, %mulx
  call void @usev2xi8(<2 x i8> %muly)
  ret <2 x i1> %cmp
}

define i1 @mul_mixed_nuw_nsw_xy_z_setodd_ult(i8 %x, i8 %y, i8 %zi) {
; CHECK-LABEL: @mul_mixed_nuw_nsw_xy_z_setodd_ult(
; CHECK-NEXT:    [[Z:%.*]] = or i8 [[ZI:%.*]], 1
; CHECK-NEXT:    [[MULX:%.*]] = mul nsw i8 [[X:%.*]], [[Z]]
; CHECK-NEXT:    [[MULY:%.*]] = mul nuw nsw i8 [[Y:%.*]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[MULX]], [[MULY]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %z = or i8 %zi, 1
  %mulx = mul nsw i8 %x, %z
  %muly = mul nuw nsw i8 %y, %z
  %cmp = icmp ult i8 %mulx, %muly
  ret i1 %cmp
}

define i1 @mul_nuw_xy_z_assumenonzero_uge(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @mul_nuw_xy_z_assumenonzero_uge(
; CHECK-NEXT:    [[NZ:%.*]] = icmp ne i8 [[Z:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[NZ]])
; CHECK-NEXT:    [[MULX:%.*]] = mul nuw i8 [[X:%.*]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i8 [[Y:%.*]], [[X]]
; CHECK-NEXT:    call void @use(i8 [[MULX]])
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %nz = icmp ne i8 %z, 0
  call void @llvm.assume(i1 %nz)
  %mulx = mul nuw i8 %x, %z
  %muly = mul nuw i8 %y, %z
  %cmp = icmp uge i8 %muly, %mulx
  call void @use(i8 %mulx)
  ret i1 %cmp
}

define <2 x i1> @mul_nuw_xy_z_setnonzero_vec_eq(<2 x i8> %x, <2 x i8> %y, <2 x i8> %zi) {
; CHECK-LABEL: @mul_nuw_xy_z_setnonzero_vec_eq(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %z = or <2 x i8> %zi, <i8 41, i8 12>
  %mulx = mul nuw <2 x i8> %z, %x
  %muly = mul nuw <2 x i8> %z, %y
  %cmp = icmp eq <2 x i8> %mulx, %muly
  ret <2 x i1> %cmp
}

define i1 @mul_nuw_xy_z_brnonzero_ult(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @mul_nuw_xy_z_brnonzero_ult(
; CHECK-NEXT:    [[NZ_NOT:%.*]] = icmp eq i8 [[Z:%.*]], 0
; CHECK-NEXT:    br i1 [[NZ_NOT]], label [[FALSE:%.*]], label [[TRUE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
; CHECK:       false:
; CHECK-NEXT:    call void @use(i8 [[Z]])
; CHECK-NEXT:    ret i1 true
;
  %nz = icmp ne i8 %z, 0
  br i1 %nz, label %true, label %false
true:
  %mulx = mul nuw i8 %x, %z
  %muly = mul nuw i8 %y, %z
  %cmp = icmp ult i8 %muly, %mulx
  ret i1 %cmp
false:
  call void @use(i8 %z)
  ret i1 true
}

define i1 @reused_mul_nuw_xy_z_selectnonzero_ugt(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @reused_mul_nuw_xy_z_selectnonzero_ugt(
; CHECK-NEXT:    [[NZ_NOT:%.*]] = icmp eq i8 [[Z:%.*]], 0
; CHECK-NEXT:    [[MULX:%.*]] = mul nuw i8 [[X:%.*]], [[Z]]
; CHECK-NEXT:    [[MULY:%.*]] = mul nuw i8 [[Y:%.*]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[MULY]], [[MULX]]
; CHECK-NEXT:    [[R:%.*]] = select i1 [[NZ_NOT]], i1 true, i1 [[CMP]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %nz = icmp ne i8 %z, 0
  %mulx = mul nuw i8 %x, %z
  %muly = mul nuw i8 %y, %z
  %cmp = icmp ugt i8 %muly, %mulx
  %r = select i1 %nz, i1 %cmp, i1 true
  ret i1 %r
}

define <2 x i1> @mul_mixed_nsw_nuw_xy_z_setnonzero_vec_ule(<2 x i8> %x, <2 x i8> %y, <2 x i8> %zi) {
; CHECK-LABEL: @mul_mixed_nsw_nuw_xy_z_setnonzero_vec_ule(
; CHECK-NEXT:    [[Z:%.*]] = or <2 x i8> [[ZI:%.*]], <i8 1, i8 3>
; CHECK-NEXT:    [[MULX:%.*]] = mul nuw <2 x i8> [[X:%.*]], [[Z]]
; CHECK-NEXT:    [[MULY:%.*]] = mul nsw <2 x i8> [[Z]], [[Y:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule <2 x i8> [[MULY]], [[MULX]]
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %z = or <2 x i8> %zi, <i8 1, i8 3>
  %mulx = mul nuw <2 x i8> %x, %z
  %muly = mul nsw <2 x i8> %z, %y
  %cmp = icmp ule <2 x i8> %muly, %mulx
  ret <2 x i1> %cmp
}

define i1 @icmp_eq_mul_nsw_nonequal(i8 %a, i8 %c) {
; CHECK-LABEL: @icmp_eq_mul_nsw_nonequal(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[C:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %b = add i8 %a, 1
  %mul1 = mul nsw i8 %a, %c
  %mul2 = mul nsw i8 %b, %c
  %cmp = icmp eq i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @icmp_eq_mul_nuw_nonequal(i8 %a, i8 %c) {
; CHECK-LABEL: @icmp_eq_mul_nuw_nonequal(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[C:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %b = add i8 %a, 1
  %mul1 = mul nuw i8 %a, %c
  %mul2 = mul nuw i8 %b, %c
  %cmp = icmp eq i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @icmp_eq_mul_nsw_nonequal_commuted(i8 %a, i8 %c) {
; CHECK-LABEL: @icmp_eq_mul_nsw_nonequal_commuted(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[C:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %b = add i8 %a, 1
  %mul1 = mul nsw i8 %a, %c
  %mul2 = mul nsw i8 %c, %b
  %cmp = icmp eq i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @icmp_ne_mul_nsw_nonequal(i8 %a, i8 %c) {
; CHECK-LABEL: @icmp_ne_mul_nsw_nonequal(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[C:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %b = add i8 %a, 1
  %mul1 = mul nsw i8 %a, %c
  %mul2 = mul nsw i8 %b, %c
  %cmp = icmp ne i8 %mul1, %mul2
  ret i1 %cmp
}

; Negative tests

define i1 @icmp_eq_mul_nsw_mayequal(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: @icmp_eq_mul_nsw_mayequal(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL1:%.*]] = mul nsw i8 [[A:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[MUL2:%.*]] = mul nsw i8 [[B:%.*]], [[C]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[MUL1]], [[MUL2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %mul1 = mul nsw i8 %a, %c
  %mul2 = mul nsw i8 %b, %c
  %cmp = icmp eq i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @icmp_eq_mul_nsw_nuw_nonequal(i8 %a, i8 %c) {
; CHECK-LABEL: @icmp_eq_mul_nsw_nuw_nonequal(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = add i8 [[A:%.*]], 1
; CHECK-NEXT:    [[MUL1:%.*]] = mul nsw i8 [[A]], [[C:%.*]]
; CHECK-NEXT:    [[MUL2:%.*]] = mul nuw i8 [[B]], [[C]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[MUL1]], [[MUL2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %b = add i8 %a, 1
  %mul1 = mul nsw i8 %a, %c
  %mul2 = mul nuw i8 %b, %c
  %cmp = icmp eq i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @icmp_ult_mul_nsw_nonequal(i8 %a, i8 %c) {
; CHECK-LABEL: @icmp_ult_mul_nsw_nonequal(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = add i8 [[A:%.*]], 1
; CHECK-NEXT:    [[MUL1:%.*]] = mul nsw i8 [[A]], [[C:%.*]]
; CHECK-NEXT:    [[MUL2:%.*]] = mul nsw i8 [[B]], [[C]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[MUL1]], [[MUL2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %b = add i8 %a, 1
  %mul1 = mul nsw i8 %a, %c
  %mul2 = mul nsw i8 %b, %c
  %cmp = icmp ult i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @icmp_mul_nsw_slt(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_mul_nsw_slt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %mul1 = mul nsw i8 %x, 7
  %mul2 = mul nsw i8 %y, 7
  %cmp = icmp slt i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @icmp_mul_nsw_sle(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_mul_nsw_sle(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sle i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %mul1 = mul nsw i8 %x, 7
  %mul2 = mul nsw i8 %y, 7
  %cmp = icmp sle i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @icmp_mul_nsw_sgt(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_mul_nsw_sgt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %mul1 = mul nsw i8 %x, 7
  %mul2 = mul nsw i8 %y, 7
  %cmp = icmp sgt i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @icmp_mul_nsw_sge(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_mul_nsw_sge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %mul1 = mul nsw i8 %x, 7
  %mul2 = mul nsw i8 %y, 7
  %cmp = icmp sge i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @icmp_mul_nsw_slt_neg(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_mul_nsw_slt_neg(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %mul1 = mul nsw i8 %x, -7
  %mul2 = mul nsw i8 %y, -7
  %cmp = icmp slt i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @icmp_mul_nsw_slt_neg_var(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @icmp_mul_nsw_slt_neg_var(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND:%.*]] = icmp slt i8 [[Z:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[COND]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %cond = icmp slt i8 %z, 0
  call void @llvm.assume(i1 %cond)
  %mul1 = mul nsw i8 %x, %z
  %mul2 = mul nsw i8 %y, %z
  %cmp = icmp slt i8 %mul1, %mul2
  ret i1 %cmp
}

; Negative tests

define i1 @icmp_mul_nonsw_slt(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_mul_nonsw_slt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL1:%.*]] = mul i8 [[X:%.*]], 7
; CHECK-NEXT:    [[MUL2:%.*]] = mul nsw i8 [[Y:%.*]], 7
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[MUL1]], [[MUL2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %mul1 = mul i8 %x, 7
  %mul2 = mul nsw i8 %y, 7
  %cmp = icmp slt i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @icmp_mul_nsw_slt_unknown_sign(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @icmp_mul_nsw_slt_unknown_sign(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL1:%.*]] = mul nsw i8 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    [[MUL2:%.*]] = mul nsw i8 [[Y:%.*]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[MUL1]], [[MUL2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %mul1 = mul nsw i8 %x, %z
  %mul2 = mul nsw i8 %y, %z
  %cmp = icmp slt i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @icmp_mul_nsw_slt_may_be_zero(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @icmp_mul_nsw_slt_may_be_zero(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i8 [[Z:%.*]], -1
; CHECK-NEXT:    call void @llvm.assume(i1 [[COND]])
; CHECK-NEXT:    [[MUL1:%.*]] = mul nsw i8 [[X:%.*]], [[Z]]
; CHECK-NEXT:    [[MUL2:%.*]] = mul nsw i8 [[Y:%.*]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[MUL1]], [[MUL2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %cond = icmp sgt i8 %z, -1
  call void @llvm.assume(i1 %cond)

  %mul1 = mul nsw i8 %x, %z
  %mul2 = mul nsw i8 %y, %z
  %cmp = icmp slt i8 %mul1, %mul2
  ret i1 %cmp
}

define i1 @test_icmp_slt_mul_known_sgt(i64 %x, i64 %z) {
; CHECK-LABEL: @test_icmp_slt_mul_known_sgt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i64 [[Z:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %y = add nsw i64 %x, 1
  %mul1 = mul nsw i64 %x, %z
  %mul2 = mul nsw i64 %y, %z
  %cmp = icmp slt i64 %mul1, %mul2
  ret i1 %cmp
}

define i1 @test_icmp_sle_mul_known_sgt(i64 %x, i64 %z) {
; CHECK-LABEL: @test_icmp_sle_mul_known_sgt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i64 [[Z:%.*]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %y = add nsw i64 %x, 1
  %mul1 = mul nsw i64 %x, %z
  %mul2 = mul nsw i64 %y, %z
  %cmp = icmp sle i64 %mul1, %mul2
  ret i1 %cmp
}

define i1 @test_icmp_mul_known_slt(i64 %x, i64 %z) {
; CHECK-LABEL: @test_icmp_mul_known_slt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i64 [[Z:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %y = add nsw i64 %x, 1
  %mul1 = mul nsw i64 %x, %z
  %mul2 = mul nsw i64 %y, %z
  %cmp = icmp slt i64 %mul2, %mul1
  ret i1 %cmp
}

define i1 @test_icmp_slt_mul_known_sgt_commuted1(i64 %x, i64 %z) {
; CHECK-LABEL: @test_icmp_slt_mul_known_sgt_commuted1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i64 [[Z:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %y = add nsw i64 %x, 1
  %mul1 = mul nsw i64 %z, %x
  %mul2 = mul nsw i64 %y, %z
  %cmp = icmp slt i64 %mul1, %mul2
  ret i1 %cmp
}

define i1 @test_icmp_slt_mul_known_sgt_commuted2(i64 %x, i64 %z) {
; CHECK-LABEL: @test_icmp_slt_mul_known_sgt_commuted2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i64 [[Z:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %y = add nsw i64 %x, 1
  %mul1 = mul nsw i64 %x, %z
  %mul2 = mul nsw i64 %z, %y
  %cmp = icmp slt i64 %mul1, %mul2
  ret i1 %cmp
}

define i1 @test_icmp_slt_mul_unknown(i64 %x, i64 %z) {
; CHECK-LABEL: @test_icmp_slt_mul_unknown(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[Y:%.*]] = add i64 [[X:%.*]], 1
; CHECK-NEXT:    [[MUL1:%.*]] = mul nsw i64 [[X]], [[Z:%.*]]
; CHECK-NEXT:    [[MUL2:%.*]] = mul nsw i64 [[Z]], [[Y]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i64 [[MUL1]], [[MUL2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %y = add i64 %x, 1
  %mul1 = mul nsw i64 %x, %z
  %mul2 = mul nsw i64 %z, %y
  %cmp = icmp slt i64 %mul1, %mul2
  ret i1 %cmp
}

define i1 @test_icmp_slt_mul_no_nsw(i64 %x, i64 %z) {
; CHECK-LABEL: @test_icmp_slt_mul_no_nsw(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[Y:%.*]] = add nsw i64 [[X:%.*]], 1
; CHECK-NEXT:    [[MUL1:%.*]] = mul i64 [[X]], [[Z:%.*]]
; CHECK-NEXT:    [[MUL2:%.*]] = mul nsw i64 [[Z]], [[Y]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i64 [[MUL1]], [[MUL2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %y = add nsw i64 %x, 1
  %mul1 = mul i64 %x, %z
  %mul2 = mul nsw i64 %z, %y
  %cmp = icmp slt i64 %mul1, %mul2
  ret i1 %cmp
}
