; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx90a -passes=atomic-expand %s | FileCheck -check-prefix=GFX90A %s

declare i32 @llvm.amdgcn.workitem.id.x()

define amdgpu_kernel void @divergent_cfg(ptr addrspace(1) %out, float %in) #0 {
; GFX90A-LABEL: @divergent_cfg(
; GFX90A-NEXT:  entry:
; GFX90A-NEXT:    [[TID:%.*]] = call i32 @llvm.amdgcn.workitem.id.x()
; GFX90A-NEXT:    [[D_CMP:%.*]] = icmp ult i32 [[TID]], 16
; GFX90A-NEXT:    br i1 [[D_CMP]], label [[IF:%.*]], label [[ELSE:%.*]]
; GFX90A:       if:
; GFX90A-NEXT:    [[TMP0:%.*]] = load float, ptr addrspace(1) [[OUT:%.*]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP0]], [[IF]] ], [ [[TMP4:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[IN:%.*]]
; GFX90A-NEXT:    [[TMP1:%.*]] = bitcast float [[NEW]] to i32
; GFX90A-NEXT:    [[TMP2:%.*]] = bitcast float [[LOADED]] to i32
; GFX90A-NEXT:    [[TMP3:%.*]] = cmpxchg ptr addrspace(1) [[OUT]], i32 [[TMP2]], i32 [[TMP1]] seq_cst seq_cst, align 4
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP3]], 1
; GFX90A-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP3]], 0
; GFX90A-NEXT:    [[TMP4]] = bitcast i32 [[NEWLOADED]] to float
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    br label [[ENDIF:%.*]]
; GFX90A:       else:
; GFX90A-NEXT:    [[TMP5:%.*]] = load float, ptr addrspace(1) [[OUT]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START2:%.*]]
; GFX90A:       atomicrmw.start2:
; GFX90A-NEXT:    [[LOADED3:%.*]] = phi float [ [[TMP5]], [[ELSE]] ], [ [[TMP9:%.*]], [[ATOMICRMW_START2]] ]
; GFX90A-NEXT:    [[NEW4:%.*]] = fadd float [[LOADED3]], [[IN]]
; GFX90A-NEXT:    [[TMP6:%.*]] = bitcast float [[NEW4]] to i32
; GFX90A-NEXT:    [[TMP7:%.*]] = bitcast float [[LOADED3]] to i32
; GFX90A-NEXT:    [[TMP8:%.*]] = cmpxchg ptr addrspace(1) [[OUT]], i32 [[TMP7]], i32 [[TMP6]] seq_cst seq_cst, align 4
; GFX90A-NEXT:    [[SUCCESS5:%.*]] = extractvalue { i32, i1 } [[TMP8]], 1
; GFX90A-NEXT:    [[NEWLOADED6:%.*]] = extractvalue { i32, i1 } [[TMP8]], 0
; GFX90A-NEXT:    [[TMP9]] = bitcast i32 [[NEWLOADED6]] to float
; GFX90A-NEXT:    br i1 [[SUCCESS5]], label [[ATOMICRMW_END1:%.*]], label [[ATOMICRMW_START2]]
; GFX90A:       atomicrmw.end1:
; GFX90A-NEXT:    br label [[ENDIF]]
; GFX90A:       endif:
; GFX90A-NEXT:    [[COMBINE:%.*]] = phi float [ [[TMP4]], [[ATOMICRMW_END]] ], [ [[TMP9]], [[ATOMICRMW_END1]] ]
; GFX90A-NEXT:    store float [[COMBINE]], ptr addrspace(1) [[OUT]], align 4
; GFX90A-NEXT:    ret void
;
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %d_cmp = icmp ult i32 %tid, 16
  br i1 %d_cmp, label %if, label %else

if:
  %res_if = atomicrmw fadd ptr addrspace(1) %out, float %in seq_cst
  br label %endif

else:
  %res_else = atomicrmw fadd ptr addrspace(1) %out, float %in seq_cst
  br label %endif

endif:
  %combine = phi float [%res_if, %if], [%res_else, %else]
  store float %combine, ptr addrspace(1) %out
  ret void
}

attributes #0 = { "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
